/************************************************************/
/* PROJECT NAME: PLL	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V2.00b		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example Phase locked loop configuration for LPC2100		*/
/*															*/
/* Demonstrates setup of PLL and VPB divider				*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board keil MCB21000								*/
/************************************************************/

#include <LPC210x.H>

void init_PLL(void);


int main(void)
{
init_PLL();		                     // Configure the PLL and VPB divider
									 //This is normally done in the startup code 
									 //but for this example the startup config is disabled
while(1)                        	 //main loop
{
;                                	 //Idle
}
}


void init_PLL(void)
{
PLLCFG = 0x00000024;				      	// Set multiplier and divider of PLL to give 60.00 Mhz
PLLCON = 0x00000001;				      	// Enable the PLL

PLLFEED = 0x000000AA;						// Update PLL registers with feed sequence
PLLFEED = 0x00000055;

while (!(PLLSTAT & 0x00000400)) 			// test Lock bit
{
;
}
PLLCON = 0x00000003;				      	// Connect the PLL

PLLFEED = 0x000000AA;				   		//Update PLL registers
PLLFEED = 0x00000055;

VPBDIV = 0x00000002;				      	//Set the VLSI peripheral bus to 30.000Mhz
}

